/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSShipwreckEndConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import net.minecraft.class_7059;

public class ShipwreckEndStructure<C extends RSShipwreckEndConfig>
extends AbstractBaseStructure<C> {
    public ShipwreckEndStructure(Codec<C> codec) {
        super(codec, ShipwreckEndStructure::isShipwreckEndFeatureChunk, ShipwreckEndStructure::generateShipwreckEndPieces);
    }

    protected static <CC extends RSShipwreckEndConfig> boolean isShipwreckEndFeatureChunk(class_6834.class_6835<CC> context) {
        int zBlockPos;
        class_1923 chunkPos = context.comp_309();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), context.comp_306().method_16398(), chunkPos.method_8328());
        RSShipwreckEndConfig config = (RSShipwreckEndConfig)context.comp_310();
        int radius = config.distanceFromOrigin;
        int xBlockPos = context.comp_309().method_8326();
        if (xBlockPos * xBlockPos + (zBlockPos = context.comp_309().method_8328()) * zBlockPos <= radius * radius) {
            return false;
        }
        int checkRadius = 16;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                class_4966 blockView = context.comp_306().method_26261(xOffset + blockPos.method_10263(), zOffset + blockPos.method_10260(), context.comp_311());
                int topY = context.comp_306().method_18028(xOffset + blockPos.method_10263(), zOffset + blockPos.method_10260(), class_2902.class_2903.field_13194, context.comp_311());
                for (int yOffset = 0; yOffset <= 10; yOffset += 5) {
                    mutable.method_10101((class_2382)blockPos).method_10100(xOffset, topY - yOffset, zOffset);
                    if (!blockView.method_32892(mutable.method_10264()).method_26215()) continue;
                    return false;
                }
            }
        }
        for (class_5321<class_7059> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.comp_306().method_41053(structureSetToAvoid, context.comp_308(), chunkPos.field_9181, chunkPos.field_9180, config.structureAvoidRadius)) continue;
            return false;
        }
        return ShipwreckEndStructure.getGenerationHeight(context.comp_309(), context.comp_306(), context.comp_311()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.comp_306()), config.minYAllowed);
    }

    private static int getGenerationHeight(class_1923 chunkPos1, class_2794 chunkGenerator, class_5539 heightLimitView) {
        int x = chunkPos1.field_9181 * 16;
        int z = chunkPos1.field_9180 * 16;
        int heightmap1 = chunkGenerator.method_18028(x + 5, z, class_2902.class_2903.field_13194, heightLimitView);
        int heightmap2 = chunkGenerator.method_18028(x, z + 5, class_2902.class_2903.field_13194, heightLimitView);
        int heightmap3 = chunkGenerator.method_18028(x - 5, z, class_2902.class_2903.field_13194, heightLimitView);
        int heightmap4 = chunkGenerator.method_18028(x, z - 5, class_2902.class_2903.field_13194, heightLimitView);
        return Math.min(Math.min(heightmap1, heightmap2), Math.min(heightmap3, heightmap4));
    }

    public static <CC extends RSShipwreckEndConfig> Optional<class_6622<CC>> generateShipwreckEndPieces(class_6834.class_6835<CC> context) {
        RSShipwreckEndConfig config = (RSShipwreckEndConfig)context.comp_310();
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), ShipwreckEndStructure.getGenerationHeight(context.comp_309(), context.comp_306(), context.comp_311()), context.comp_309().method_8328());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(blockpos, pieces));
    }
}

